# Podstawowe importy
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.image as im


# Tworzy tablice zer o wymiarach 5x8
tab = np.zeros((5,8))

# nrows = liczba wierszy, ncols = liczba kolumn (rozpakowywanie krotki)
nrows, ncols = tab.shape

# najmniejszy wymiar (min z wierszy i kolumn)
min_shape = min(nrows, ncols)


# Ustawia trzecia (indeks 2) kolumne na 1
for i in range(nrows):
    tab[i][2] = 1


# Ustawia czwarty (indeks 3) wiersz na 2
for i in range(ncols):
    tab[3][i] = 2


# Ustawia "przekatna" z lewego gornego rogu na 3
for i in range(min_shape):
    tab[i][i] = 3


# Ustawia "przekatna" z lewego gornego rogu na 4
for i in range(min_shape):
    tab[i][min_shape - i - 1] = 4


# Wyswietla wynik jako obrazek
# Argument cmap to mapa kolorow
plt.imshow(tab, cmap='viridis_r')
plt.show()