from faker import Faker
import random
import sqlite3
import numpy as np

faker = Faker(locale="pl")

N_OSOB = 100

imiona_zwierzat = {
  "pies": [
    "Burek", "Reksio", "Azor", "Max", "Luna", "Bella",
    "Rocky", "Tina", "Bruno", "Dżeki", "Milo", "Kora"
  ],
  "kot": [
    "Mruczek", "Filemon", "Kicia", "Simba", "Mila", "Leo",
    "Loki", "Nela", "Puszek", "Feliks", "Tosia", "Zorro"
  ],
  "papuga": [
    "Kiwi", "Lola", "Rio", "Mango", "Coco", "Polly",
    "Sky", "Bingo", "Tiki", "Ariel", "Paco", "Zazu"
  ],
  "chomik": [
    "Puszek", "Nugat", "Tofik", "Karmel", "Fistaszek", "Drops",
    "Migdał", "Bąbel", "Rufi", "Pixel", "Kokos", "Gizmo"
  ],
  "żółw": [
    "Leonardo", "Skorupka", "Turbo", "Shelly", "Donatello",
    "Rafaello", "Mirek", "Stefan", "Tuptuś", "Gucio"
  ]
}

def gen_zwierze(id):
    gatunek = random.choice(list(imiona_zwierzat.keys()))
    imie = random.choice(imiona_zwierzat[gatunek])
    wiek = random.randint(1, 10)
    czy_zyje = np.random.choice([1, 0], p=[0.8, 0.2])
    return id, imie, wiek, gatunek, czy_zyje

zwierzeta = []
relacje = []

def gen_osobe(id):
    imie, nazwisko = faker.unique.first_name(), faker.unique.last_name()
    wiek = random.randint(1, 100)
    ma_zwierze = np.random.choice([True, False], p=[0.8, 0.2])
    if ma_zwierze:
        for _ in range(random.randint(1, 5)):
            zwierzeta.append(gen_zwierze(len(zwierzeta)))
            relacje.append((id, len(zwierzeta)-1))
    return id, imie, nazwisko, wiek

osoby = [
    gen_osobe(i)
    for i in range(N_OSOB)
]

base = sqlite3.connect("zwierzeta.db")
base.cursor().executescript('''
CREATE TABLE IF NOT EXISTS osoby (id INTEGER PRIMARY KEY, imie TEXT, nazwisko TEXT, wiek INTEGER);
CREATE TABLE IF NOT EXISTS zwierzeta (id INTEGER PRIMARY KEY, imie TEXT, wiek INTEGER, gatunek TEXT, czy_zyje INTEGER);
CREATE TABLE IF NOT EXISTS osoby_zwierzeta (id_osoby INTEGER, id_zwierzecia INTEGER);
DELETE FROM osoby;
DELETE FROM zwierzeta;
DELETE FROM osoby_zwierzeta;
''')
base.commit()

base.cursor().executemany("INSERT INTO osoby (id, imie, nazwisko, wiek) VALUES (?, ?, ?, ?)", osoby)
base.cursor().executemany("INSERT INTO zwierzeta (id, imie, wiek, gatunek, czy_zyje) VALUES (?, ?, ?, ?, ?)", zwierzeta)
base.cursor().executemany("INSERT INTO osoby_zwierzeta (id_osoby, id_zwierzecia) VALUES (?, ?)", relacje)
base.commit()