from pyvis.network import Network

net = Network(directed=False)

net.show_buttons(filter_=['physics', 'nodes', 'edges'])

net.repulsion(
    node_distance=100,
    central_gravity=0.2,
    spring_length=200,
    spring_strength=0.05,
    damping=0.09
)

net.add_nodes(['Wroclaw', 'Rzeszow', 'Poznan', 'Torun', 'Warszawa', 'Lublin', 'Krakow', 'Katowice'],
              color=['red', 'lightgreen', 'black', 'yellow', 'lime', 'blue', 'brown', 'gray'])

net.add_edges([
    ('Wroclaw', 'Poznan'),
    ('Wroclaw', 'Katowice'),
    ('Poznan', 'Warszawa'),
    ('Poznan', 'Torun'),
    ('Torun', 'Warszawa'),
    ('Krakow', 'Warszawa'),
    ('Katowice', 'Krakow'),
    ('Krakow', 'Rzeszow'),
    ('Lublin', 'Rzeszow'),
    ('Lublin', 'Warszawa'),
])

net.save_graph('moja_siec.html')